// By EVOLVED
// www.evolved-software.com

//--------------
// tweaks
//--------------
   float2 ViewSize0;
   float2 ViewSize1;
   float2 ViewSize2;
   float2 ViewSize3;
   float MiddleGray=0.1;
   float4 Brightness={1.1,1.1,1.1,1.0};
   float CoreBrightness=0.1;
   float GlowBrightness=0.1;
   float HazeBrightness=0.1;
   float Sharpen=0.5;
   float ColorVibrance=0.25;
   float GrayScale=0.0;

//--------------
// Textures
//--------------
   texture RenderTexture <string Name = " ";>;
   sampler RenderSampler=sampler_state 
      {
	Texture=<RenderTexture>;
      	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
      };
   texture CoreTexture <string Name = " ";>;
   sampler CoreSampler=sampler_state 
      {
	Texture=<CoreTexture>;
     	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
      };
   texture GlowTexture <string Name = " ";>;
   sampler GlowSampler=sampler_state 
      {
	Texture=<GlowTexture>;
     	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
      };
   texture HazeTexture <string Name = " ";>;
   sampler HazeSampler=sampler_state 
      {
	Texture=<HazeTexture>;
     	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
      };
   texture AdaptedLumTexture <string Name = " ";>;
   sampler AdaptedLumSampler=sampler_state 
      {
	Texture=<AdaptedLumTexture>;
     	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
     };
   struct OutPut
     {
	float4 Pos:POSITION; 
 	float2 Tex:TEXCOORD0;
 	float2 Tex1:TEXCOORD1;
 	float2 Tex2:TEXCOORD2;
 	float2 Tex3:TEXCOORD3;
 	float2 Tex4:TEXCOORD4;
 	float2 Tex5:TEXCOORD5;
 	float2 Tex6:TEXCOORD6;
 	float2 Tex7:TEXCOORD7;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=IN.Pos;
 	OUT.Tex=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewSize0;
	OUT.Tex1=OUT.Tex-ViewSize0.xy*2.0;
	OUT.Tex2=OUT.Tex+ViewSize0.xy*2.0;
	OUT.Tex3=OUT.Tex+float2(ViewSize0.x,-ViewSize0.y)*2.0;
	OUT.Tex4=OUT.Tex+float2(-ViewSize0.x,ViewSize0.y)*2.0;
 	OUT.Tex5=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewSize1;
 	OUT.Tex6=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewSize2;
 	OUT.Tex7=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewSize3;
	return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS(OutPut IN) : COLOR
     {
	float4 FrameRender=tex2D(RenderSampler,IN.Tex);
  	float LumaNW=dot(tex2D(RenderSampler,IN.Tex1).xyz,float3(0.299,0.587,0.114));
   	float LumaNE=dot(tex2D(RenderSampler,IN.Tex3).xyz,float3(0.299,0.587,0.114));
   	float LumaSW=dot(tex2D(RenderSampler,IN.Tex4).xyz,float3(0.299,0.587,0.114));
   	float LumaSE=dot(tex2D(RenderSampler,IN.Tex2).xyz,float3(0.299,0.587,0.114));
        float2 Dir=float2(-((LumaNW+LumaNE)-(LumaSW+LumaSE)),(LumaNW+LumaSW)-(LumaNE+LumaSE));
   	float DirReduce=max((LumaNW+LumaNE+LumaSW+LumaSE)*0.03125,0.0078125);
   	Dir *=1.0/(min(abs(Dir.x),abs(Dir.y))+DirReduce);
   	Dir=min(8,max(-8,Dir))*(ViewSize0.xy*2);
   	float3 rgbA=0.5*(tex2D(RenderSampler,IN.Tex+Dir*(1.0/3.0-0.5)).xyz+tex2D(RenderSampler,IN.Tex+Dir*(2.0/3.0-0.5)).xyz);
   	float3 rgbB=rgbA*0.5+0.25*(tex2D(RenderSampler,IN.Tex+Dir*(0.0/3.0-0.5)).xyz+tex2D(RenderSampler,IN.Tex+Dir*(3.0/3.0-0.5)).xyz);
   	float LumaB=dot(rgbB,float3(0.299,0.587,0.114));
        float LumaM=dot(FrameRender.xyz,float3(0.299,0.587,0.114));
        float LumaMin=min(LumaM,min(min(LumaNW,LumaNE),min(LumaSW,LumaSE)));
        float LumaMax=max(LumaM,max(max(LumaNW,LumaNE),max(LumaSW,LumaSE)));
	if((LumaB<LumaMin) || (LumaB>LumaMax)) rgbB=rgbA;
	rgbA=(LumaNW+LumaSE+LumaNE+LumaSW)*0.25;
	rgbA=rgbB+clamp(dot(rgbB,float3(0.299,0.587,0.114))-rgbA,-Sharpen,Sharpen);
	FrameRender.xyz=max(rgbA,0.0);
	float3 Bloom=tex2D(CoreSampler,IN.Tex5).xyz*CoreBrightness
	            +tex2D(GlowSampler,IN.Tex6).xyz*GlowBrightness
	            +tex2D(HazeSampler,IN.Tex7).xyz*HazeBrightness;
 	FrameRender.xyz +=Bloom.xyz;
	float AdaptedLum=tex1D(AdaptedLumSampler,0);
	FrameRender.xyz *=MiddleGray/max(AdaptedLum,0.001);
    	FrameRender.xyz=(FrameRender.xyz*(2.51*FrameRender.xyz+0.03))/(FrameRender.xyz*(2.43*FrameRender.xyz+0.59)+0.14);
	float Lumavg=dot(float3(0.299,0.587,0.114),FrameRender.xyz);
	FrameRender.xyz=lerp(FrameRender.xyz,Lumavg,GrayScale);
	float Colorsat=max(FrameRender.x,max(FrameRender.y,FrameRender.z))-min(FrameRender.x,min(FrameRender.y,FrameRender.z));
	FrameRender.xyz=lerp(Lumavg,FrameRender.xyz,1.0+(ColorVibrance*(1.0-(sign(ColorVibrance)*Colorsat))));
	FrameRender.xyz=pow(FrameRender.xyz,0.454545);
	return float4(FrameRender.xyz*Brightness,1.0);
     }

//--------------
// techniques   
//--------------
    technique FinalComposite
      {
 	pass p1
      {		
 	VertexShader = compile vs_3_0 VS(); 
 	PixelShader  = compile ps_3_0 PS();
      }
      }
